VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "PPluginInterface"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'-----------------------------------------------------
' MirageBot Plugin Exposed Class
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public Sub HandleError(Plugin As String, Descr As String)
    frmBot.mnuError.Visible = True
    Dim FF As Integer
    FF = FreeFile
    Open AppData & "ErrorLog.txt" For Append As #FF
        Print #FF, App.Major & "." & App.Minor & "." & App.Revision & _
            "::" & Plugin & "::" & Descr
    Close #FF
End Sub


'----------------------------------------------------------------------------
'Bot Related
'----------------------------------------------------------------------------
    Public Function GetBot(Index As Integer, Optional ByRef Success As Boolean) As Object
        'Get a single Bot object
        On Error GoTo hErr:
        Set GetBot = frmBot.Bot(Index)
        Success = True
        Exit Function
hErr:     ErrorHandler Err.Description, Erl, "PluginInterface", "GetBot"
    End Function
    Public Function GetBots(Optional ByRef Success As Boolean) As Object()
        'Get all loaded Bot objects()
        On Error GoTo hErr:
        Dim P() As Object, B As BNCS, w As Boolean
        ReDim P(0)
        For Each B In frmBot.Bot
            If B.IsLoaded Then
                If Not w Then
                    Set P(0) = B
                    w = True
                Else
                    ReDim Preserve P(UBound(P) + 1)
                    Set P(UBound(P)) = B
                End If
            End If
        Next B
        GetBots = P
        Success = w
        Exit Function
hErr:     ErrorHandler Err.Description, Erl, "PluginInterface", "GetBots"
    End Function
    Public Function GetUser(Index As Integer, Username As String, Optional ByRef Success As Boolean) As Object
        On Error GoTo hErr:
        Dim B As Object, U As Object
        Set B = GetBot(Index, Success)
        If Success Then
            Set U = B.Users.GetByName(Username)
            If LenB(U.Username) Then
                Set GetUser = U
                Success = True
            Else
                Success = False
            End If
        End If
        Exit Function
hErr: 'Return Success = False
    End Function
    Public Function GetUsers(Index As Integer, Optional ByRef Success As Boolean) As Object()
        On Error GoTo hErr:
        Dim B As Object, U() As Object, G As Boolean
        Set B = GetBot(Index, G)
        If G Then
            U = B.Users.GetAll(G)
            If G Then
                GetUsers = U
                Success = True
            Else
                Success = False
            End If
        End If
        Exit Function
hErr: 'Return Success = False
    End Function
'----------------------------------------------------------------------------




'----------------------------------------------------------------------------
'TickCount Related
'----------------------------------------------------------------------------
    Public Function GetTickCount() As Double
        GetTickCount = DblTickCount
    End Function
    Public Sub FormatTick(TickCount As Double, ByRef w As Long, ByRef D As Long, ByRef h As Long, ByRef m As Long, ByRef S As Long)
        Dim DT As DATETIME
        DT = ConvertTickCount(TickCount)
        D = DT.Days
        h = DT.Hours
        m = DT.Minutes
        S = DT.Seconds
        w = DT.Weeks
    End Sub
'----------------------------------------------------------------------------



'----------------------------------------------------------------------------
'Control/Form/Object Related
'----------------------------------------------------------------------------
    Public Function GetForm() As Object
        Set GetForm = frmBot
    End Function
    Public Function GetOptions() As Object
        Set GetOptions = Options
    End Function
    Public Function GetVersion() As String
        GetVersion = frmBot.Title
    End Function
    Public Function GetTime() As String
        GetTime = ChatTime
    End Function
    Public Function GetTimeColor()
        GetTimeColor = colour.msg.mTimestamp
    End Function
    Public Function GetControl(Index As Integer, ID As Integer, Optional ByRef Success As Boolean) As Object
        On Error GoTo hErr:
        If ID = 2 Then
            Set GetControl = frmBot.lvUsers(Index)
        ElseIf ID = 1 Then
            Set GetControl = frmBot.rtbWhsp(Index)
        Else
            Set GetControl = frmBot.rtbChat(Index)
        End If
        Success = True
        Exit Function
hErr: ErrorHandler Err.Description, Erl, "PluginInterface", "GetControl"
    End Function
'----------------------------------------------------------------------------


'----------------------------------------------------------------------------
'Connection Related
'----------------------------------------------------------------------------
    Public Sub ReviewPacket(strPlugin As String, bytPacketID As Byte, strSub As String, Optional boolOverride As Boolean = True)
        Dim P As New PPacket
        P.PacketID = bytPacketID
        P.Plugin = strPlugin
        P.Routine = strSub
        P.Override = boolOverride
        OutPackets.Add P
    End Sub
    Public Sub RegisterPacket(strPlugin As String, bytPacketID As Byte, strSub As String, Optional boolOverride As Boolean = True)
        Dim P As New PPacket
        P.PacketID = bytPacketID
        P.Plugin = strPlugin
        P.Routine = strSub
        P.Override = boolOverride
        IncPackets.Add P
    End Sub
    Public Sub Send(Index As Integer, Message As String, Optional HighPriority As Boolean)
        On Error GoTo hErr:
1       If frmBot.Bot(Index).IsOnline Then
2           If HighPriority Then
3               frmBot.Bot(Index).SendAway Message, HI_PRIORITY
            Else
4               frmBot.Bot(Index).SendText Message
            End If
        Else
5           frmBot.AddChat Index, vbPaleBlue, ">> " & Message
        End If
        Exit Sub
hErr: ErrorHandler Err.Description, Erl, "PluginInterface", "Send"
    End Sub
    Public Function SendPacket(Index As Integer, PacketID As Byte, Data As String)
        frmBot.Bot(Index).SendBnetPacket2 PacketID, Data
    End Function
'----------------------------------------------------------------------------


'----------------------------------------------------------------------------
'Clan Related
'----------------------------------------------------------------------------
    Public Function GetClanRank(Index As Integer, Username As String) As Integer
        On Error GoTo hErr:
        If frmBot.Bot(Index).Clan.IsMember(Username) Then
            GetClanRank = frmBot.Bot(Index).Clan.GetByName(Username).Rank
        Else
            GetClanRank = -1
        End If
        Exit Function
hErr: ErrorHandler Err.Description, Erl, "PluginInterface", "GetClanRank"
    End Function
'----------------------------------------------------------------------------



'----------------------------------------------------------------------------
'File Management
'----------------------------------------------------------------------------
    Public Sub WriteConfig(Index As Integer, Section As String, Key As String, value As String)
        'Write Config.ini Value
        On Error Resume Next: modFileIO.WriteINI GetBot(Index).profilePath, Section, Key, value
    End Sub
    Public Function ReadConfig(Index As Integer, Section As String, Key As String) As String
        'Return Config.ini Value
        On Error Resume Next: ReadConfig = modFileIO.ReadINI(GetBot(Index).profilePath, Section, Key)
    End Function
    Public Function ReadSetting(Section As String, Key As String) As String
        'Return Settings.ini Value
        On Error Resume Next: ReadSetting = modFileIO.ReadINI(AppSettings, Section, Key)
    End Function
    Public Sub WriteSetting(Section As String, Key As String, value As String)
        'Write Settings.ini Value
        On Error Resume Next: modFileIO.WriteINI AppSettings, Section, Key, value
    End Sub
    Public Function GetBotPath() As String
        'Return App.Path
        GetBotPath = App.Path & "\"
    End Function
    Public Function GetDataPath() As String
        'Return Recommended Path for Data
        GetDataPath = AppData & "Data\Other\"
    End Function
    Public Function GetFilePath() As String
        'Return %APPDATA%\MirageBot Path
        GetFilePath = AppData
    End Function
'----------------------------------------------------------------------------





'----------------------------------------------------------------------------
'Profile Management
'----------------------------------------------------------------------------
    Public Function HideProfile(ProfileName As String) As Integer
        'Hide a Profile
        Dim bi As Integer, ti As Integer
        bi = GetProfileIndex(ProfileName)
        If bi = -1 Then HideProfile = -2: Exit Function
        If frmBot.Bot(bi).IsHidden Then HideProfile = -1: Exit Function
        UnloadTabOnly bi
        HideProfile = 0
    End Function
    Public Function LoadProfile(ProfileName As String) As Integer
        'Load a Profile
        Dim FSO As New FileSystemObject
        If FSO.FolderExists(AppData & "Profiles\" & ProfileName & "\") = False Then LoadProfile -2: Exit Function
        If IsProfileLoaded(ProfileName) Then LoadProfile = -1: Exit Function
        modManageProfiles.LoadProfile (ProfileName)
        LoadProfile = 0
    End Function
    Public Function UnhideProfile(ProfileName As String) As Integer
        'Unhide a Profile
        Dim bi As Integer
        bi = GetProfileIndex(ProfileName)
        If bi = -1 Then UnhideProfile = -2: Exit Function
        If frmBot.Bot(bi).IsHidden = False Then UnhideProfile = -1: Exit Function
        LoadTabOnly bi
        UnhideProfile = 0
    End Function
    Public Function UnloadProfile(ProfileName As String) As Integer
        'Unload a Profile
        Dim bi As Integer, ti As Integer
        bi = GetProfileIndex(ProfileName)
        If bi = -1 Then UnloadProfile = -2: Exit Function
        ti = BotToTabIndex(bi)
        If ti = -1 Then UnloadProfile = -1: Exit Function
        modManageProfiles.UnloadProfile ti
        UnloadProfile = 0
    End Function
'----------------------------------------------------------------------------




'----------------------------------------------------------------------------
'Database Related
'----------------------------------------------------------------------------
    Public Function IsRank(Rank As String) As Boolean
        'Check if Rank exists
        IsRank = rankingExists(Rank)
    End Function
    Public Function GetRank(Index As Integer, Username As String) As String
        'Return a user's Rank
        On Error GoTo hErr:
        With frmBot.Bot(Index).Database
            Dim DB As Integer
            DB = .Find(Username)
            If DB > -1 Then
                GetRank = GetRankByID(.GetUser(DB).RankID).RankName
            ElseIf DB = -2 Then
                GetRank = consoleRank
            End If
        End With
        Exit Function
hErr: ErrorHandler Err.Description, Erl, "PluginInterface", "GetRank"
    End Function
    Public Sub RegisterCommand(strPlugin As String, strCommand As String, strArgs As String, strSub As String, strHelp As String, Optional strAlias As String, Optional boolOverride As Boolean = True, Optional AccessLevel As Integer = 3)
        Dim C As New PCommand
        C.Command = strCommand
        C.Alias = strAlias
        C.Args = strArgs
        C.Help = strHelp
        C.Plugin = strPlugin
        C.AccessLevel = AccessLevel
        C.Routine = strSub
        C.Override = boolOverride
        Commands.Add C
    End Sub
'----------------------------------------------------------------------------

